using Microsoft.VisualBasic;
using System;
using System.Data;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class MoviesBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the MoviesBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MoviesBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MoviesBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MoviesBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MoviesBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected MoviesBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the MoviesBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(MoviesBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(MoviesBO_SetDefaultValues);
		}
		
		#endregion
		
		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void MoviesBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			//-- Ensure that the UPC is unique if entered
			if (mv_UPC.Length > 0 && (! IsUPCUnique()))
			{
				this.AddBrokenRule(MoviesBOFieldNames.mv_UPC, "This UPC code is already in use.");
			}
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void MoviesBO_SetDefaultValues()
		{
			mv_Rating = MovieRating.PG;
			mv_Status = MovieDVDStatus.Out;
			mv_CreatedAt = DateTime.Now;
			mv_CreatedBy = MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
		}
		
		#endregion
		
		#region " Private Methods "
		
		/// <summary>
		/// Determines if the UPC is unique
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		private bool IsUPCUnique()
		{
			//-- Establish Locals
			SqlCommand cmd = new SqlCommand("SELECT COUNT(*) FROM Movies WHERE mv_pk != @moviePk AND mv_UPC = @UPC");
			
			//-- Create the parms
			cmd.Parameters.AddWithValue("@moviePk", mv_pk).SqlDbType = SqlDbType.Int;
			cmd.Parameters.AddWithValue("@UPC", mv_UPC).SqlDbType = SqlDbType.VarChar;
			
			//-- Return the results
			return System.Convert.ToInt32(this.ExecuteScalar(cmd)) == 0;
		}
		
		#endregion
		
		#region " Public Methods "
		
		
		
		#endregion
		
	}
	
}
